<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Creates Diagram Summary Table (used in package.xsl)-->
	<xsl:template name="createDiagramSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<xsl:param name="packagePath"/>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:sort select="@name"/>
				<xsl:variable name="description">
					<xsl:apply-templates select="current()" mode="getDescription"/>
				</xsl:variable>
				<tr class="TableRow">
					<td width="15%">
						<b>
							<xsl:variable name="diagramName" select="@name"/>
							<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
						</b>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="$description"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>

	<!-- Creates Summary Table for any Set of elements (used in diagram.xsl)-->
	<xsl:template name="createDesignElementSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:variable name="element" select="key('all-by-id', @element)"></xsl:variable>
				<!-- xsl:sort select="$element/@name"/ -->
				<xsl:variable name="description">
					<xsl:apply-templates select="$element" mode="getDescription"/>
				</xsl:variable>
				<tr class="TableRow">
					<td width="15%">
						<b>
							<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
							<xsl:choose>
								
								<!-- Set reference to design element detail description -->
								<xsl:when test="$localName='DesignElement'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								
								<!-- Set reference to Classifier-->
								<xsl:when test="$localName='Classifier'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								
								<!-- Set reference to Package-->
								<xsl:when test="$localName='Package'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								<xsl:when test="$localName='Diagram'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>

								<!-- Undefined element (simply print its name)-->
								<xsl:otherwise>
									<xsl:value-of select="$element/@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</b>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="$description"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>

	<!-- Create Diagram Element's detail section-->
	<xsl:template name="designElementsDetail">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		
		<!-- Tests if there is at least one design element-->
		<xsl:variable name="testEmpty">
			<xsl:call-template name="testNodeSet">
				<xsl:with-param name="nodeset" select="$nodeSet"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:if test="string-length($testEmpty) &gt; 0">
			<table border="1" cellpadding="3" cellspacing="0" width="100%">
			  <tr class="TableHeaderStyle">
			    <td colspan="2">
				  <font size="+2">
					<b><xsl:value-of select="$title"/></b>
				  </font>
				</td>
			  </tr>
			</table>
			<br/>
			<xsl:for-each select="$nodeSet">
				<!-- xsl:sort select="@elementName" / -->

				<xsl:variable name="element" select="key('all-by-id', @element)"></xsl:variable>
				<xsl:variable name="localName" select="local-name($element)"></xsl:variable>

				<xsl:if test="$localName='DesignElement'">
					<xsl:variable name="elementName" select="string($element/@name)"/>
					<xsl:variable name="elementRef">
						<xsl:apply-templates select="$element" mode="unique_reference"></xsl:apply-templates>
					</xsl:variable>
	
					<xsl:variable name="description">
						<xsl:apply-templates select="$element" mode="getDescription"/>
					</xsl:variable>
					<!--a name="{$elementName}"><h3><xsl:value-of select="$elementName"/></h3></a-->
					<a name="{$elementRef}"><h3><xsl:value-of select="$elementName"/></h3></a>
					<pre>
					</pre>
					
					<!-- Print Element Properties-->
					<xsl:call-template name="printProperties">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
						<xsl:with-param name="nodeset" select="$element/Property"></xsl:with-param>
						<xsl:with-param name="property-names" select="$element/Property/@name"></xsl:with-param>			
					</xsl:call-template>
					
					<!-- Print Reference Properties-->
					<xsl:call-template name="printProperties">
						<xsl:with-param name="element" select="current()"></xsl:with-param>
						<xsl:with-param name="nodeset" select="current()/Property[not(@name=$element/Property/@name)]"></xsl:with-param>
						<xsl:with-param name="property-names" select="current()/Property[not(@name=$element/Property/@name)]/@name"></xsl:with-param>
					</xsl:call-template>
					
					<!--test inner design elements-->
					<!--xsl:variable name="link_metaclasses" select="$element//Link/@metaclass"></xsl:variable-->
					<xsl:variable name="link_metaclasses" select="key('links-metaclasses', 'all')"/>
					<xsl:call-template name="designElementsSummary">
						<xsl:with-param name="diagram" select="current()"></xsl:with-param>
						<xsl:with-param name="nodeset" select="DiagramReference"></xsl:with-param>
						<xsl:with-param name="metaclasses" select="DiagramReference[not(@metaclass=$link_metaclasses)]/@metaclass"></xsl:with-param>
						<xsl:with-param name="packagePath" select="''"></xsl:with-param>
					</xsl:call-template>
					<!-- Print Element Links-->
					<xsl:call-template name="printLinksEx">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
						<xsl:with-param name="metaclasses" select="$element/Link/@metaclass"></xsl:with-param>			
						<xsl:with-param name="link_refs" select="$nodeSet[@element=$element/Link/@id]"></xsl:with-param>
					</xsl:call-template>
					
					<xsl:if test="$viewType='diagram'">
					<!-- Print Inner Element Links -->
						<xsl:call-template name="printInnerLinks">	
							<xsl:with-param name="element" select="$element"/>
							<xsl:with-param name="metaclasses" select="$element/DesignElement//Link/@metaclass"/>
							<xsl:with-param name="link_refs" select="$nodeSet[@element=$element//Link/@id]"/>
						</xsl:call-template>
					</xsl:if>
					
					<!-- Print Element HyperLinks-->
					<xsl:call-template name="printHyperLinks">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
					</xsl:call-template>
					<hr/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>		

	</xsl:template>
	
	<xsl:template match="DesignElement" mode="unique_reference">
			<xsl:value-of select="concat('Ref',@id)"></xsl:value-of>
	</xsl:template>
	
	<!-- Selects only Design Elements-->
	<xsl:template name="testNodeSet">
		<xsl:param name="nodeset"></xsl:param>
		<xsl:for-each select="$nodeset">
			<xsl:variable name="element" select="key('all-by-id', @element)"></xsl:variable>
			<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
			<xsl:if test="$localName='DesignElement'">
				<xsl:value-of select="$element/@name"></xsl:value-of>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="testNodeSetPackage">
		<xsl:param name="nodeset"></xsl:param>
		<xsl:for-each select="$nodeset">
			<xsl:if test="local-name()='DesignElement'">
				<xsl:value-of select="@name"></xsl:value-of>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="packageElementsSummary">
		<xsl:param name="nodeSet"/>
		<xsl:param name="metaclasses"/>
		
			<xsl:variable name="first" select="$metaclasses[1]"></xsl:variable>
			<xsl:if test="$first">
				<xsl:variable name="shapeType" select="string($first)"></xsl:variable>
			
			<xsl:variable name="codeSummary">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'summary'"/>
					<xsl:with-param name="p1" select="$shapeType"/>
				</xsl:call-template>				
			</xsl:variable>
			
			<xsl:call-template name="createPackageDesignElementSummaryTable">
					<xsl:with-param name="title" select="$codeSummary"/>
					<xsl:with-param name="nodeSet" select="$nodeSet[@metaclass=$shapeType]"/>
			</xsl:call-template>

			<xsl:call-template name="packageElementsSummary">
				<xsl:with-param name="nodeSet" select="$nodeSet"></xsl:with-param>
				<xsl:with-param name="metaclasses" select="$metaclasses[not(string($shapeType)=string(.))]"></xsl:with-param>
			</xsl:call-template>
			</xsl:if>
	</xsl:template>
	
	<!-- Creates Summary Table for any Set of elements (used in diagram.xsl)-->
	<xsl:template name="createPackageDesignElementSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<!--xsl:param name="diagramName"/-->
		<!--xsl:param name="packagePath"/-->
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:variable name="element" select="current()"/>
				<!-- xsl:sort select="$element/@name"/ -->
				<xsl:variable name="description">
					<xsl:apply-templates select="$element" mode="getDescription"/>
				</xsl:variable>
				<tr class="TableRow">
					<td width="15%">
						<b>
							<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
							<xsl:choose>
								
								<!-- Set reference to design element detail description -->
								<xsl:when test="$localName='DesignElement'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								
								<!-- Set reference to Classifier-->
								<xsl:when test="$localName='Classifier'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								
								<!-- Set reference to Package-->
								<xsl:when test="$localName='Package'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>
								<xsl:when test="$localName='Diagram'">
									<xsl:apply-templates select="$element" mode="HRefWithImgLoad"/>
								</xsl:when>

								<!-- Undefined element (simply print its name)-->
								<xsl:otherwise>
									<xsl:value-of select="$element/@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</b>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="$description"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>
	
	<xsl:template name="packageElementsDetail">
		<xsl:param name="title" />
		<xsl:param name="nodeSet" />

		<!-- Tests if there is at least one design element-->
		<xsl:variable name="testEmpty">
			<xsl:call-template name="testNodeSetPackage">
				<xsl:with-param name="nodeset" select="$nodeSet"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:if test="string-length($testEmpty) &gt; 0">
			<table border="1" cellpadding="3" cellspacing="0" width="100%">
			  <tr class="TableHeaderStyle">
			    <td colspan="2">
				  <font size="+2">
					<b><xsl:value-of select="$title"/></b>
				  </font>
				</td>
			  </tr>
			</table>
			<br/>
			<xsl:for-each select="$nodeSet">
				<!-- xsl:sort select="@elementName" / -->

				<xsl:variable name="element" select="current()"></xsl:variable>
				<xsl:variable name="localName" select="local-name($element)"></xsl:variable>

				<xsl:if test="$localName='DesignElement'">
					<xsl:variable name="elementName" select="string($element/@name)"/>
					<xsl:variable name="elementRef">
						<xsl:apply-templates select="$element" mode="unique_reference"></xsl:apply-templates>
					</xsl:variable>
	
					<xsl:variable name="description">
						<xsl:apply-templates select="$element" mode="getDescription"/>
					</xsl:variable>
					<!--a name="{$elementName}"><h3><xsl:value-of select="$elementName"/></h3></a-->
					<a name="{$elementRef}"><h3><xsl:value-of select="$elementName"/></h3></a>
					<pre>
					</pre>
					
					<!-- Print Element Properties-->
					<xsl:call-template name="printProperties">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
						<xsl:with-param name="nodeset" select="$element/Property"></xsl:with-param>
						<xsl:with-param name="property-names" select="$element/Property/@name"></xsl:with-param>			
					</xsl:call-template>
					
					<!--test inner design elements-->
					<xsl:call-template name="packageElementsSummary">
						<xsl:with-param name="nodeSet" select="DesignElement"></xsl:with-param>
						<xsl:with-param name="metaclasses" select="DesignElement/@metaclass"></xsl:with-param>
					</xsl:call-template>
					<!-- Print Element Links-->
					<xsl:call-template name="printLinksEx">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
						<xsl:with-param name="metaclasses" select="$element/Link/@metaclass"></xsl:with-param>			
						<xsl:with-param name="link_refs" select="$nodeSet[@element=$element/Link/@id]"></xsl:with-param>
					</xsl:call-template>
					
					<!-- Print Element HyperLinks-->
					<xsl:call-template name="printHyperLinks">
						<xsl:with-param name="element" select="$element"></xsl:with-param>
					</xsl:call-template>
					<hr/>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>		
	</xsl:template>			
	
</xsl:stylesheet>
